//Experiment No.6
// This file must be used under the terms of the CeCILL.
// This source file is licensed as described in the file COPYING, which
// you should have received as part of this distribution.  The terms
// are also available at    
// http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
//This Source file is Written by Dr. T. Subbulaskhmi, Professor, 
//School of Computing Science and Engineering, VIT University Chennai 
//using the NARVAL examples of Scilab for Network Topology Creation  
//The Operating System used for writing the code found in this file is Windows 8
//SCILAB version 5.5.2 and NARVAL toolbox version 3.1//This Program is Written by Souarv kumar Surya(15bce1364),Prayag Bhatia (15bce1363),Maaz Ahmed (15bce1261), School of Computing Science and Engineering, VIT University Chennai using the NARVAL examples of Scilab for finding the shortest path 
//This is the scilab code to find the Shortest path from source to destination in bus topology network using flood for 12 nodes. 
clear;
clc;
NameOfNetwork='Shortest path from s-->d in bus topology with 12 nodes using flood';// graph name
NumberOfNodes=12;//no. of nodes
//every edge has head and tail.
EndingNodesOfConnection=[1 2 3 4 5 6 2 3 4 5 6];//Ending Node of the connection 
StartNodesOfConnection=[2 3 4 5 6 7 8 9 10 11 12];//Starting Nodes of the connection lines
// so, an edge can be represent as (tail,head),tail and head both are node no. eg.:   tail[1]=2,head[1]=1 means edge 1 is originating from 2 and terminating on 1 that implies there is an edge betweem node 1 and   node 2
XCoordinatesOfNodes=[100 150 300 400 550 600 700 150 300 400 550 600];// x-coordinate of each node
YCoordinatesOfNodes=[300 300 300 300 300 300 300 500 500 200 600 100];//y-coordinate of each node
[TopologyGraph]=NL_G_MakeGraph(NameOfNetwork,NumberOfNodes,EndingNodesOfConnection,StartNodesOfConnection,XCoordinatesOfNodes,YCoordinatesOfNodes)//Creates the Bus topoplogy
NetworkSize=length(TopologyGraph.node_x);//Real network size
NeworkLinkQuantity=length(TopologyGraph.head);//Quantity of network links
[ne,nr]=NL_F_RandIntNiNj(NetworkSize)//Random Selection of two distinct nodes
TimeToLive=15;//Time-To-Live update
[path]=NL_R_Flood(TopologyGraph,ne,nr,TimeToLive)//Application of NL_R_Flood
ShortestPathLinks=NL_G_Nodes2Path(path,TopologyGraph);//Links of the shortest path
EdgeColor=ones(1,NeworkLinkQuantity);//Display the path between i and j: edge color
EdgeBorder=1.5*ones(1,NeworkLinkQuantity);//Edge width
EdgeColor(ShortestPathLinks)=5;//Define path color
EdgeBorder(ShortestPathLinks)=5;//Define width 
NodeBorder=4*ones(1,NetworkSize);//Node border
NodeBorder(path)=10;//Node border for source to destination path
TopologyGraph.node_border=NodeBorder;//Node border
TopologyGraph.edge_color=EdgeColor;//Define edge color
TopologyGraph.edge_width=EdgeBorder;//Edge width
windownumber=1;//window index
GraphVisualize=NL_G_ShowGraphN(TopologyGraph,windownumber);//graph visualization
xtitle("Shortest path in Bus Topology network using flood for 12 nodes","X-Nodes","Y-Nodes");

//This is scilab code to find the Shortest path from source to destination in bus topology network using flood for 30 nodes. 
NameofNetwork='Shortest path from s-->d in bus topology with 30 nodes using flood';// graph name
NumberOfNodes=30;//no. of nodes
//every edge has StartingNodesOfConnection and tail.
EndingNodesOfConnection=[1 2 23 3 29 4 24 5 6 25 7 13 14 15 16 2 23 3 29 4 24 5 6 25 7 13 14 15 16];// tail of eatch edge, this is a node from a edge or link is originating 
StartingNodesOfConnection=[2 23 3 29 4 24 5 6 25 7 13 14 15 16 17 8 26 9 30 10 27 11 12 28 18 19 20 21 22];//head of each edge,this is a node where edge or link is terminating 
// so, an edge can be represent as (tail,head),tail and head both are node no. eg.:   tail[1]=2,head[1]=1 means edge 1 is originating from 2 and terminating on 1 that implies there is an edge betweem node 1 and   node 2
XCoordinatesOfNodes=[100 150 300 400 550 600 700 150 300 400 550 600 750 800 850 900 950 700 750 800 850 900 200 500 650 200 500 650 350 350];// x-coordinate of each node
YCoordinatesOfNodes=[300 300 300 300 300 300 300 500 500 200 600 100 300 300 300 300 300 200 400 500 100 100 300 300 300 500 200 250 300 100];//y-coordinate of each node
[TopologyGraph]=NL_G_MakeGraph(NameofNetwork,NumberOfNodes,EndingNodesOfConnection,StartingNodesOfConnection,XCoordinatesOfNodes,YCoordinatesOfNodes)//application of NL_G_MakeGraph
NetworkSize=length(TopologyGraph.node_x);//real network size
NeworkLinkQuantity=length(TopologyGraph.head);//quantity of network links
[Node1,Node2]=NL_F_RandIntNiNj(NetworkSize)//selection of two distinct nodes
TTL=15;//Time-To-Live update
[path]=NL_R_Flood(TopologyGraph,Node1,Node2,TTL)//application of NL_R_Flood
ShortestPathLinks=NL_G_Nodes2Path(path,TopologyGraph);//links of the shortest path
EdgeColor=ones(1,NeworkLinkQuantity);//display the path between i and j: edge color
EdgeBorder=1.5*ones(1,NeworkLinkQuantity);//edge width
EdgeColor(ShortestPathLinks)=5;//define path color
EdgeBorder(ShortestPathLinks)=5;//define width 
NodeBorder=4*ones(1,NetworkSize);//node border
NodeBorder(path)=10;//node border for source to destination path
TopologyGraph.node_border=NodeBorder;//node border
TopologyGraph.edge_color=EdgeColor;//define edge color
TopologyGraph.edge_width=EdgeBorder;//edge width
WindowIndex=2;//window index
GraphVisualize=NL_G_ShowGraphN(TopologyGraph,WindowIndex);//graph visualization
xtitle("Shortest path in Bus Topology network using flood for 30 nodes","X-Nodes","Y-Nodes");

